library ATPComments;

uses
  SysUtils, Classes, Dialogs;

function ProcessText(Text: Pchar): PChar; stdcall;
var
  SText: String;
  SL: TStringList;
  i: integer;
  AllCommented: Boolean;

  function IsCommented(const Text: String): Boolean;
  begin
    Result := Pos('//',Trim(Text)) = 1
  end;

begin
  SText := String(Text);

  // Utiliza a classe TStrings para processar as linhas do Texto;
  SL := TStringList.Create;
  try
    SL.Text := SText;
    SText := '';

    AllCommented := true;

    // Verifica se todas as linhas esto comentadas
    for i := 0 to SL.Count - 1 do begin
      if not IsCommented(SL[i]) then
       AllCommented := false;
    end;

    // Varre as linhas e comenta ou descomenta
    for i := 0 to SL.Count - 1 do begin


      if AllCommented then
        // se j estava comentado, remove comentrio
        SL[i] := StringReplace(SL[i],'//','',[])
      else
        // seno adiciona comentrio
        SL[i] := '//' + SL[i];
    end;

    SText := SL.Text;

  finally
    SL.Free;

    // Aloca Memria para o String de retorno (+1 para ter espao para o terminador nulo do string)
    GetMem(Result,Length(SText)+1);

    // Copia o String para a rea de memria alocada
    Result := StrPCopy(Result,SText);

  end;
end;

function GetDescription: PChar; stdcall;
begin
  Result := Pchar('Adicionar/Remover Comentrios');
end;

function GetShortCut: PChar; stdcall;
begin
  Result := Pchar('SHIFT+CTRL+ALT+C');
end;


exports ProcessText, GetDescription, GetShortCut;



{$R *.res}

begin
end.
